# Intufind AI Plugin

## Development Configuration

### Setting the API Endpoint for Local Development

The Intufind Cloud service supports multiple ways to configure the API endpoint for local development:

#### 1. Environment Variable (Recommended for Development)

Set the `INTUFIND_API_URL` environment variable:

```bash
export INTUFIND_API_URL=http://localhost:3000
```

Or in your `.env` file (if using a .env loader):

```
INTUFIND_API_URL=http://localhost:3000
```

#### 2. WordPress Constant (wp-config.php)

Add to your `wp-config.php` file:

```php
define('INTUFIND_API_URL', 'http://localhost:3000');
```

#### 3. WordPress Option (Admin Interface)

Set through the WordPress admin interface in the Intucart settings.

#### Priority Order

The endpoint is determined in this order:

1. Environment variable (`INTUFIND_API_URL`)
2. WordPress constant (`INTUFIND_API_URL`)
3. WordPress option (`intucart_cloud_endpoint`)
4. Default production endpoint (`https://api.intufind.com`)

### Examples

- Local development: `http://localhost:3000`
- Docker development: `http://host.docker.internal:3000`
- Staging environment: `https://staging-api.intufind.com`
- Production (default): `https://api.intufind.com`

## Environment File Setup

### Using .env Files

The plugin automatically loads `.env` files from the plugins directory (`plugins/.env`) for local development. This uses the `vlucas/phpdotenv` library.

#### Setup Steps:

1. **Create a .env file** in the `plugins/` directory (not in the plugin subdirectory):

```bash
# In plugins/.env
INTUFIND_API_URL=http://localhost:3000
APP_ENV=development
```

2. **The plugin will automatically load** the .env file on initialization

3. **Environment variables are available** throughout the plugin via the `Environment` helper class

### Environment Helper Class

The plugin includes a powerful `Environment` helper class for working with environment variables:

```php
use Intucart\Services\Environment;

// Get environment variables with defaults
$endpoint = Environment::getString('INTUFIND_API_URL', 'https://api.intufind.com');
$debug = Environment::getBool('INTUCART_DEBUG', false);
$timeout = Environment::getInt('API_TIMEOUT', 30);

// Check if variables are set
if (Environment::has('CUSTOM_API_KEY')) {
    // Use custom API key
}

// Environment detection
if (Environment::isDevelopment()) {
    // Development-specific code
}

// Get multiple variables at once
$config = Environment::getMultiple([
    'INTUFIND_API_URL',
    'API_TIMEOUT',
    'DEBUG_MODE'
], [
    'INTUFIND_API_URL' => 'https://api.intufind.com',
    'API_TIMEOUT' => 30,
    'DEBUG_MODE' => false
]);
```

### Security Notes

- Never commit `.env` files to version control
- Use `.env.example` files to document required variables
- The plugin silently handles missing .env files for production deployments
- Environment variables take precedence over WordPress options for security
