/**
 * Chatbot Sub-tabs Handler
 * Handles tab switching within the chatbot settings page
 */
(($) => {
    $(document).ready(() => {
        $('.intucart-nav-tabs a').on('click', function (e) {
            var href = $(this).attr('href');

            // Only intercept settings/styling/woocommerce subtabs
            if (
                href.indexOf('chatbot_subtab=settings') !== -1 ||
                href.indexOf('chatbot_subtab=styling') !== -1 ||
                href.indexOf('chatbot_subtab=woocommerce') !== -1
            ) {
                e.preventDefault();

                // Update active tab state
                $('.itf-inner-tabs a').removeClass('itf-inner-tab-active');
                $(this).addClass('itf-inner-tab-active');

                // Hide all tab content
                $('#chatbot-settings-tab, #chatbot-styling-tab, #chatbot-woocommerce-tab').hide();

                // Show the selected tab content
                if (href.indexOf('chatbot_subtab=settings') !== -1) {
                    $('#chatbot-settings-tab').show();
                } else if (href.indexOf('chatbot_subtab=styling') !== -1) {
                    $('#chatbot-styling-tab').show();
                } else if (href.indexOf('chatbot_subtab=woocommerce') !== -1) {
                    $('#chatbot-woocommerce-tab').show();
                }

                // Update URL without page reload
                if (history.pushState) {
                    history.pushState(null, null, href);
                }
            }
        });
    });
})(jQuery);
