/**
 * Content Types Form Handler
 * Handles AJAX submission for content type preferences
 */
(($) => {
    $(document).ready(() => {
        const $form = $('#intucart-content-types-form');

        if (!$form.length) {
            return;
        }

        // Store original checkbox states
        $form.find('input[type="checkbox"]').each(function () {
            $(this).data('original-state', $(this).prop('checked'));
        });

        $form.on('submit', function (e) {
            e.preventDefault();

            const $saveButton = $form.find('button[type="submit"]');

            const toastId = showToast('loading', 'Saving content preferences...', {
                id: 'content-types-save',
                persistent: true,
            });

            $saveButton.prop('disabled', true).text('Saving...');

            const formData = new FormData(this);
            formData.append('action', 'intucart_update_content_types');
            formData.append('nonce', intucartAdmin.nonce);

            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                timeout: 30000,
                success: (response) => {
                    if (response.success) {
                        updateToast(toastId, 'success', response.data.message, {
                            autoDismiss: true,
                            dismissDelay: 5000,
                        });
                        // Update original states after successful save
                        $form.find('input[type="checkbox"]').each(function () {
                            $(this).data('original-state', $(this).prop('checked'));
                        });
                    } else {
                        const errorMsg = response.data?.message || response.data || 'Unknown error occurred';
                        updateToast(toastId, 'error', errorMsg, { autoDismiss: false });
                    }
                },
                error: (xhr, status) => {
                    const errorMsg =
                        status === 'timeout'
                            ? 'Request timed out. Please try again.'
                            : `Server error (${xhr.status}): ${xhr.statusText}`;
                    updateToast(toastId, 'error', errorMsg, { autoDismiss: false });
                },
                complete: () => {
                    $saveButton.prop('disabled', false).text('Save Content Types');
                },
            });
        });
    });
})(jQuery);
