/**
 * MCP Sync Button Handler
 * Handles the reconnect/sync button for MCP configuration
 */
(($) => {
    $(document).ready(() => {
        $('#intucart-mcp-sync-btn').on('click', function (e) {
            e.preventDefault();
            var $btn = $(this);

            // Disable button and show loading state
            $btn.prop('disabled', true).addClass('itf-btn-disabled').find('.itf-btn-text').text('Connecting...');
            $btn.find('.itf-btn-icon svg').addClass('spin');

            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'intucart_sync_mcp_config',
                    nonce: intucartMcpSync.nonce,
                },
                success: (response) => {
                    if (response.success) {
                        location.reload();
                    } else {
                        alert(`Connection failed: ${response.data?.message || 'Please try again or contact support.'}`);
                        resetButton($btn);
                    }
                },
                error: () => {
                    alert('Connection failed: Please check your internet connection and try again.');
                    resetButton($btn);
                },
            });
        });

        function resetButton($btn) {
            $btn.prop('disabled', false).removeClass('itf-btn-disabled').find('.itf-btn-text').text('Reconnect');
            $btn.find('.itf-btn-icon svg').removeClass('spin');
        }
    });
})(jQuery);
