jQuery(document).ready(($) => {
  // Media Uploader Logic
  $(document).on('click', '.upload-button', function (e) {
    e.preventDefault();
    const button = $(this);
    const uploaderContainer = button.closest('.intucart-image-uploader');
    const imageIdInput = uploaderContainer.find('input[type="hidden"]');
    const previewWrapper = uploaderContainer.find('.intucart-image-preview-wrapper');
    const removeButton = uploaderContainer.find('.remove-button');

    const frame = wp.media({
      title: 'Select or Upload Avatar',
      button: {
        text: 'Use this image',
      },
      multiple: false,
    });

    frame.on('select', () => {
      const attachment = frame.state().get('selection').first().toJSON();
      imageIdInput.val(attachment.id);

      let previewHtml = ''; // Default to empty preview
      if (attachment.type === 'image') {
        // Prefer thumbnail if it exists
        if (attachment.sizes?.thumbnail?.url) {
          previewHtml = `<img src="${attachment.sizes.thumbnail.url}" style="display:block; width: 100%; height: 100%; object-fit: cover; border-radius: 50%;"/>`;
        }
        // Fallback to full image URL if thumbnail missing
        else if (attachment.url) {
          previewHtml = `<img src="${attachment.url}" style="display:block; width: 100%; height: 100%; object-fit: cover; border-radius: 50%;"/>`;
        }
        // Final fallback to icon if URL is missing for an image type
        else if (attachment.icon) {
          previewHtml = `<img src="${attachment.icon}" style="display:block; width: 80%; height: auto; margin: 10%;"/>`;
        }
      } else if (attachment.icon) {
        // Use icon for non-image types
        previewHtml = `<img src="${attachment.icon}" style="display:block; width: 80%; height: auto; margin: 10%;"/>`;
      }

      previewWrapper.html(previewHtml); // Set the preview HTML (might be empty)
      removeButton.show(); // Always show remove button once something is selected
    });

    frame.open();
  });

  // Remove Image Logic
  $(document).on('click', '.remove-button', function (e) {
    e.preventDefault();
    const button = $(this);
    const uploaderContainer = button.closest('.intucart-image-uploader');
    const imageIdInput = uploaderContainer.find('input[type="hidden"]');
    const previewWrapper = uploaderContainer.find('.intucart-image-preview-wrapper');

    imageIdInput.val('0');
    previewWrapper.html(''); // Clear preview
    button.hide();
  });
});
