/**
 * Sync Meta Box Handler
 * Handles the sync/searchable checkbox interdependency in the post editor
 */
(function($) {
    'use strict';

    $(document).ready(function() {
        var $syncCheckbox = $('#intucart_exclude_from_sync');
        var $searchCheckbox = $('#intucart_hide_from_search');
        
        // Exit if meta box elements don't exist
        if (!$syncCheckbox.length || !$searchCheckbox.length) {
            return;
        }

        var $searchLabel = $searchCheckbox.closest('label');
        var $searchDescription = $searchCheckbox.closest('div').find('.description');
        
        // Get state from localized data
        var isPrivatePost = window.intucartSyncMetabox?.isPrivatePost || false;
        var isSyncableStatus = window.intucartSyncMetabox?.isSyncableStatus || false;

        function updateSearchableState() {
            var isSyncExcluded = $syncCheckbox.is(':checked');
            
            if (!isSyncableStatus) {
                // Non-syncable status (draft, pending, etc.)
                $searchCheckbox.prop('disabled', true).prop('checked', true);
                $searchLabel.css('opacity', '0.5');
                $searchDescription.html('⚠ Publish to enable search control.');
            } else if (isPrivatePost) {
                // Private posts always have search disabled
                $searchCheckbox.prop('disabled', true).prop('checked', true);
                $searchLabel.css('opacity', '0.5');
                $searchDescription.html('🔒 Private posts are always hidden from search (chatbot-only access).');
            } else if (isSyncExcluded) {
                // Disable searchable control if not synced
                $searchCheckbox.prop('disabled', true);
                $searchLabel.css('opacity', '0.5');
                $searchDescription.html('⚠ Content must be indexed first to control search visibility.');
            } else {
                // Enable searchable control if synced
                $searchCheckbox.prop('disabled', false);
                $searchLabel.css('opacity', '1');
                
                var isSearchable = !$searchCheckbox.is(':checked');
                if (isSearchable) {
                    $searchDescription.html('✓ Visible in search results.');
                } else {
                    $searchDescription.html('✗ Hidden from search results (AI can still reference).');
                }
            }
        }

        // Update on checkbox change
        $syncCheckbox.on('change', updateSearchableState);
        $searchCheckbox.on('change', updateSearchableState);

        // Initial state
        updateSearchableState();
    });
})(jQuery);

