jQuery(function ($) {
  $(".ajax_add_to_cart").each(function () {
    $(this)
      .off("click")
      .on("click", function (e) {
        e.preventDefault();
        var $thisbutton = $(this);

        if ($thisbutton.hasClass("disabled")) {
          return;
        }

        var data = {
          action: "woocommerce_add_to_cart",
          product_id: $thisbutton.data("product_id"),
          quantity: $thisbutton.data("quantity"),
          security: $thisbutton.data("nonce"),
        };

        $thisbutton.addClass("loading");
        $thisbutton.find(".wc-block-components-product-button__spinner").show();

        $(document.body).trigger("adding_to_cart", [$thisbutton, data]);

        $.ajax({
          type: "POST",
          url: wc_add_to_cart_params.ajax_url,
          data: data,
          dataType: "json",
          success: function (response) {
            if (response && !response.error) {
              $(document.body).trigger("wc_fragment_refresh");
              $(document.body).trigger("added_to_cart", [
                response.fragments,
                response.cart_hash,
                $thisbutton,
              ]);
              $thisbutton.removeClass("loading").addClass("added");
              $thisbutton.next(".added_to_cart").remove();
              // Update button text with quantity
              var currentQty = parseInt($thisbutton.data("quantity")) || 1;
              var newQty =
                currentQty +
                (response.fragments["cart_count"]
                  ? parseInt(response.fragments["cart_count"])
                  : 0);
              $thisbutton.text(newQty + " in Cart");
            } else if (response.error && response.product_url) {
              window.location = response.product_url;
            }
            $thisbutton
              .find(".wc-block-components-product-button__spinner")
              .hide();
          },
          error: function (xhr, status, error) {
            $thisbutton.removeClass("loading");
            $thisbutton
              .find(".wc-block-components-product-button__spinner")
              .hide();
            console.log("Add to cart failed: " + error);
          },
        });
      });
  });
});
