<?php

declare(strict_types=1);

namespace Intucart\Admin\Tabs;

/**
 * Interface for admin tab renderers
 */
interface TabRendererInterface
{
    /**
     * Get the tab identifier
     *
     * @return string
     */
    public function getId(): string;

    /**
     * Get the tab configuration for the tabs component
     *
     * @return array{url: string, label: string, icon: string, condition?: bool}
     */
    public function getTabConfig(): array;

    /**
     * Render the tab content
     *
     * @return void
     */
    public function render(): void;
}

