<?php

declare(strict_types=1);

namespace Intucart\Admin\Tabs;

use Intucart\Services\Logger;
use Intucart\Services\Constants;
use Intucart\Pages\Settings\WebhookSettings;
use Intucart\Components\Button;

/**
 * Renders the Webhooks tab in admin settings
 */
class WebhooksTabRenderer extends AbstractTabRenderer
{
    private WebhookSettings $webhookSettings;

    public function __construct(Logger $logger, WebhookSettings $webhookSettings)
    {
        parent::__construct($logger);
        $this->webhookSettings = $webhookSettings;
    }

    public function getId(): string
    {
        return 'webhooks';
    }

    public function getTabConfig(): array
    {
        return [
            'url' => '?page=intucart&tab=webhooks',
            'label' => __('Webhooks', 'intufind'),
            'icon' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path opacity=".4" d="M288,0a32,32,0,0,0-32,32V160h64V32A32,32,0,0,0,288,0ZM96,0A32,32,0,0,0,64,32V160h64V32A32,32,0,0,0,96,0Z"/><path d="M384,176v32a16,16,0,0,1-16,16H352v32A160.07,160.07,0,0,1,224,412.8V512H160V412.8A160.07,160.07,0,0,1,32,256V224H16A16,16,0,0,1,0,208V176a16,16,0,0,1,16-16H368A16,16,0,0,1,384,176Z"/></svg>'
        ];
    }

    public function render(): void
    {
        $this->renderHeader(
            __('Webhook Configuration', 'intufind'),
            sprintf(
                __('Configure webhook endpoints to receive real-time notifications when events occur in your %s system. Webhooks allow you to integrate with external services and automate workflows based on chat interactions, content changes, and user activities.', 'intufind'),
                Constants::PLUGIN_NAME
            )
        );

        echo '<form id="webhook-main-settings-form" action="options.php" method="post" novalidate>';
        settings_fields(Constants::SETTINGS_GROUP_WEBHOOKS);

        $this->webhookSettings->renderWebhookBasicSettings();
        $this->webhookSettings->renderWebhookEndpoints();
        $this->webhookSettings->renderWebhookEventsReference();

        echo '<p class="submit">';
        Button::primary(__('Save Webhook Settings', 'intufind'), [
            'type' => 'submit',
            'id' => 'submit',
            'attributes' => ['name' => 'submit']
        ]);
        echo '</p>';
        echo '</form>';
    }
}

