<?php

namespace Intucart\Base;

/**
 * Settings links class
 */
class SettingsLinks
{
    /**
     * Register settings links
     *
     * @return void
     */
    public function initialize(): void
    {
        add_filter(
            "plugin_action_links_" . INTUCART_PLUGIN_BASENAME,
            array($this, 'settingsLink')
        );
    }

    /**
     * Add settings link to plugin
     *
     * @param array $links Array of plugin action links.
     *
     * @return array Modified array of plugin action links
     */
    public function settingsLink(array $links): array
    {
        $settings_link = '<a href="admin.php?page=intucart">Settings</a>';
        array_unshift($links, $settings_link);
        return $links;
    }
}
