<?php

declare(strict_types=1);

namespace Intucart\DI;

use Intucart\Services\Search;
use Intucart\Services\Recommendations;
use Intucart\Services\AIClientManager;
use Intucart\Services\Managers\PostTypeManager;
use Intucart\Services\Managers\CronManager;
use Intucart\Services\Managers\EventManager;
use Intucart\Services\Managers\TaxonomyManager;
use Intucart\Services\Logger;
use Intucart\Services\Cache\CacheService;
use Intucart\Services\Analytics;
use Intucart\Services\Licensing\License;
use Intucart\Services\Mcp\McpAuthHandler;
use Intucart\Services\Mcp\McpServer;
use Intucart\Services\Mcp\McpToolsManager;

/**
 * Service Provider for Feature/Business Logic services.
 * Includes Search, Recommendations, Managers, and related business services.
 */
class FeatureServicesProvider
{
    /**
     * Returns the definitions for the container.
     *
     * @return array Definitions for the container.
     */
    public function getDefinitions(): array
    {
        return [
            // === SEARCH & RECOMMENDATIONS ===

            Search::class => \DI\create()
                ->constructor(
                    \DI\get(AIClientManager::class),
                    \DI\get(Logger::class),
                    \DI\get(CacheService::class),
                    \DI\get(Analytics::class),
                    \DI\get(License::class)
                ),

            Recommendations::class => \DI\create()
                ->constructor(
                    \DI\get(PostTypeManager::class),
                    \DI\get(EventManager::class),
                    \DI\get(CacheService::class),
                    \DI\get(Logger::class),
                    \DI\get(License::class),
                    \DI\get(AIClientManager::class)
                ),

            // === MANAGER SERVICES ===

            CronManager::class => \DI\create()
                ->constructor(
                    \DI\get(PostTypeManager::class),
                    \DI\get(TaxonomyManager::class),
                    \DI\get(Logger::class),
                    \DI\get(License::class)
                ),

            EventManager::class => \DI\create()
                ->constructor(
                    \DI\get(Logger::class),
                    \DI\get(CacheService::class)
                ),

            TaxonomyManager::class => \DI\create()
                ->constructor(
                    \DI\get(Logger::class),
                    \DI\get(AIClientManager::class),
                    \DI\get(CacheService::class)
                ),

            // === MCP SERVICES ===

            McpAuthHandler::class => \DI\create()
                ->constructor(
                    \DI\get(Logger::class)
                ),

            McpToolsManager::class => \DI\create()
                ->constructor(
                    \DI\get(Logger::class),
                    \DI\get(McpAuthHandler::class)
                ),

            McpServer::class => \DI\create()
                ->constructor(
                    \DI\get(Logger::class),
                    \DI\get(McpAuthHandler::class),
                    \DI\get(McpToolsManager::class)
                ),
        ];
    }
}
