<?php

namespace Intucart\DI;

use Intucart\Services\CacheAdmin;
use Intucart\Integration\RecommendationsOverride;
use Intucart\Integration\SearchOverride;
use Intucart\Shortcodes\AssistantChatShortcode;
use Intucart\Shortcodes\SearchWidgetShortcode;
use Intucart\Base\Enqueue;
use Intucart\Services\Providers\Events\WooCommerceEventProvider;
use Intucart\Services\Recommendations;
use Intucart\Services\Search;
use Intucart\Services\AIClientManager;
use Intucart\Services\Cache\CacheService;
use Intucart\Services\Logger;
use Intucart\Services\Analytics;
use Intucart\Services\Licensing\License;
use Intucart\Services\Managers\EventManager;
use Intucart\Services\Managers\TaxonomyManager;
use Intucart\Services\Managers\PostTypeManager;
use Intucart\Services\Mcp\McpServer;
use Intucart\Admin\SyncMetaBox;
use Intucart\Admin\SyncAdmin;
use Intucart\Pages\Status;
use Intucart\Services\UsageService;

/**
 * Service Provider for Presentation layer services.
 * Includes Integrations and Shortcodes.
 */
class PresentationServicesProvider
{
    /**
     * Returns the definitions for the container.
     *
     * @return array Definitions for the container.
     */
    public function getDefinitions(): array
    {
        return [
            // === ADMIN SERVICES ===

            CacheAdmin::class => \DI\create()
                ->constructor(\DI\get(CacheService::class)),

            // Enqueue service with DI of AIClientManager, cache, and license
            Enqueue::class => \DI\create()
                ->constructor(
                    \DI\get(AIClientManager::class),
                    \DI\get(CacheService::class),
                    \DI\get(License::class)
                ),

            Status::class => \DI\create()
                ->constructor(
                    \DI\get(Logger::class),
                    \DI\get(License::class),
                    \DI\get(CacheService::class),
                    \DI\get(AIClientManager::class),
                    \DI\get(McpServer::class),
                    \DI\get(UsageService::class),
                    \DI\get(PostTypeManager::class),
                    \DI\get(TaxonomyManager::class)
                ),

            SyncMetaBox::class => \DI\create()
                ->constructor(
                    \DI\get(Logger::class),
                    \DI\get(PostTypeManager::class)
                ),

            SyncAdmin::class => \DI\create()
                ->constructor(
                    \DI\get(Logger::class),
                    \DI\get(PostTypeManager::class),
                    \DI\get(AIClientManager::class)
                ),

            // === INTEGRATIONS ===

            RecommendationsOverride::class => \DI\create()
                ->constructor(
                    \DI\get(Recommendations::class),
                    \DI\get(Logger::class),
                    \DI\get(Analytics::class),
                    \DI\get(License::class)
                ),

            SearchOverride::class => \DI\create()
                ->constructor(
                    \DI\get(Search::class),
                    \DI\get(Logger::class)
                ),

            WooCommerceEventProvider::class => \DI\create()
                ->constructor(\DI\get(EventManager::class)),

            // === SHORTCODES ===

            AssistantChatShortcode::class => \DI\create(),
            
            SearchWidgetShortcode::class => \DI\create(),
        ];
    }
}
