<?php

namespace Intucart\Database;

/**
 * Database schema
 */
class Schema
{
    /**
     * Create plugin database tables
     *
     * @return void
     */
    public static function createTables(): void
    {
        global $wpdb;

        $charset_collate = $wpdb->get_charset_collate();

        $sql = [
            "CREATE TABLE IF NOT EXISTS " .
                "{$wpdb->prefix}intucart_product_relationships (
                product1_id bigint(20) NOT NULL,
                product2_id bigint(20) NOT NULL,
                purchase_count int NOT NULL DEFAULT 1,
                last_purchased datetime NOT NULL,
                PRIMARY KEY (product1_id, product2_id)
            ) $charset_collate;",

            // Search Analytics Table
            "CREATE TABLE IF NOT EXISTS " .
                "{$wpdb->prefix}intucart_search_analytics (
                id bigint(20) NOT NULL AUTO_INCREMENT,
                search_term varchar(255) NOT NULL,
                results_count int(11) NOT NULL,
                created_at datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
                PRIMARY KEY  (id),
                KEY search_term (search_term),
                KEY created_at (created_at)
            ) $charset_collate;",

            // Recommendation Analytics Table
            "CREATE TABLE IF NOT EXISTS " .
                "{$wpdb->prefix}intucart_recommendation_analytics (
                id bigint(20) NOT NULL AUTO_INCREMENT,
                product_id bigint(20) NOT NULL,
                source_product_id bigint(20) NOT NULL,
                recommendation_type varchar(20) NOT NULL,
                impression_count int NOT NULL DEFAULT 1,
                total_score decimal(10,4) NOT NULL DEFAULT 0,
                last_updated datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                PRIMARY KEY (id),
                UNIQUE KEY unique_recommendation (product_id, source_product_id, recommendation_type),
                KEY product_id (product_id),
                KEY source_product_id (source_product_id),
                KEY recommendation_type (recommendation_type)
            ) $charset_collate;",

            // Logs Table
            "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}intucart_logs (
                id bigint(20) NOT NULL AUTO_INCREMENT,
                level varchar(20) NOT NULL,
                message text NOT NULL,
                context text,
                created_at datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
                PRIMARY KEY (id),
                KEY level (level),
                KEY created_at (created_at)
            ) $charset_collate;"
        ];

        include_once ABSPATH . 'wp-admin/includes/upgrade.php';
        foreach ($sql as $query) {
            dbDelta($query);
        }
    }

    /**
     * Drop all plugin database tables
     *
     * @return void
     */
    public static function dropTables(): void
    {
        global $wpdb;

        $tables = [
            "{$wpdb->prefix}intucart_product_relationships",
            "{$wpdb->prefix}intucart_search_analytics",
            "{$wpdb->prefix}intucart_chat_analytics",
            "{$wpdb->prefix}intucart_recommendation_analytics",
            "{$wpdb->prefix}intucart_logs"
        ];

        foreach ($tables as $table) {
            $wpdb->query("DROP TABLE IF EXISTS {$table}");
        }
    }

}
