<?php

namespace Intucart\Services;

/**
 * Constants used throughout the plugin
 */
class Constants
{
    // Cron hooks
    public const POST_SYNC_HOOK = 'intufind_full_post_sync';
    public const TAXONOMY_SYNC_HOOK = 'intufind_full_taxonomy_sync';
    public const TRIGGER_FULL_SYNC_HOOK = 'intucart_trigger_full_sync';
    public const DAILY_CLEANUP_HOOK = 'intucart_daily_cleanup';

    // Sync completion action hooks
    public const POST_SYNC_COMPLETED_ACTION = 'intucart_post_sync_completed';
    public const TAXONOMY_SYNC_COMPLETED_ACTION = 'intucart_taxonomy_sync_completed';

    // Sync settings
    public const SYNC_INTERVAL = 'intucart_sync_interval';
    public const DEFAULT_SYNC_INTERVAL = DAY_IN_SECONDS;  // 24 hours
    public const DEFAULT_SYNC_HOUR = 2;  // 2 AM

    // Plugin settings
    public const VERSION_OPTION = 'intucart_version';

    // WordPress Settings Groups
    public const SETTINGS_GROUP_LICENSE = 'intucart_license_settings';
    public const SETTINGS_GROUP_SEARCH = 'intucart_search_settings';
    public const SETTINGS_GROUP_WOOCOMMERCE = 'intucart_woocommerce_settings';
    public const SETTINGS_GROUP_SYNC = 'intucart_sync_settings';
    public const SETTINGS_GROUP_CHAT = 'intucart_chat_settings';

    // API Key settings
    public const API_KEY_OPTION = 'intucart_api_key'; // Cloud API key (secret) from dashboard
    public const PUBLISHABLE_KEY_OPTION = 'intucart_publishable_key'; // Publishable key for widget (if_pk_)
    public const WORKSPACE_ID_OPTION = 'intucart_workspace_id'; // Workspace ID for multi-workspace isolation
    public const TENANT_ID_OPTION = 'intucart_tenant_id'; // Cloud tenant identifier
    public const TIER_OPTION = 'intucart_tier'; // Subscription tier
    public const LICENSE_NOTICE_DISMISSED_OPTION = 'intucart_license_notice_dismissed'; // API key notice dismissed
    
    // Legacy options (kept for backwards compatibility during migration)
    public const LICENSE_KEY_OPTION = 'intucart_api_key'; // Alias to API_KEY_OPTION for backwards compatibility

    // Plugin branding
    public const PLUGIN_NAME = 'Intufind AI'; // Plugin display name used in UI
    public const PLUGIN_SHORT_NAME = 'Intufind'; // Short name for compact displays
    public const PLUGIN_VERSION = INTUCART_VERSION; // Current plugin version

    // Company and website URLs
    public const WEBSITE_URL = 'https://intufind.com/'; // Main company website
    public const PRICING_URL = 'https://intufind.com/pricing/'; // Pricing page URL
    public const UPDATE_CHECK_URL = 'https://intufind.com/api/plugin/update-check'; // Plugin update check endpoint

    // Search settings
    public const ENABLE_SEMANTIC_SEARCH_OPTION = 'intucart_enable_semantic_search';
    public const ENABLE_MIXED_CONTENT_SEARCH_OPTION = 'intucart_enable_mixed_content_search';
    public const ENABLE_ENHANCED_AI_SEARCH_OPTION = 'intucart_enable_enhanced_ai_search';
    public const SEARCH_CACHE_DURATION_OPTION = 'intucart_search_cache_duration';

    // Recommendation settings
    public const RECOMMENDATION_HALF_LIFE_OPTION = 'intucart_recommendation_half_life';
    public const ENABLE_RELATED_PRODUCTS_OPTION = 'intucart_enable_related_products';
    public const ENABLE_UPSELLS_OPTION = 'intucart_enable_upsells';
    public const ENABLE_CROSS_SELLS_OPTION = 'intucart_enable_cross_sells';

    // Default recommendation weights
    public const DEFAULT_SIMILAR_PRODUCTS_WEIGHT = 0.4;
    public const DEFAULT_BASKET_AFFINITY_WEIGHT = 0.3;
    public const DEFAULT_USER_SIMILARITY_WEIGHT = 0.3;

    // Weight redistribution ratios for data quality adjustments
    public const GUEST_USER_SIMILAR_REDISTRIBUTION = 0.6;
    public const GUEST_USER_BASKET_REDISTRIBUTION = 0.4;
    public const LOW_INTERACTION_SIMILAR_REDISTRIBUTION = 0.7;
    public const LOW_INTERACTION_BASKET_REDISTRIBUTION = 0.3;
    public const HIGH_ENGAGEMENT_SIMILAR_REDISTRIBUTION = 0.6;
    public const HIGH_ENGAGEMENT_BASKET_REDISTRIBUTION = 0.4;

    // Sync settings
    public const SYNC_INTERVAL_OPTION = 'intucart_sync_interval';
    public const SYNC_HOUR_OPTION = 'intucart_sync_hour';

    // Individual post type sync timestamps
    public const LAST_PRODUCT_SYNC_OPTION = 'intucart_last_product_sync';
    public const LAST_POST_SYNC_OPTION = 'intucart_last_post_sync';
    public const LAST_PAGE_SYNC_OPTION = 'intucart_last_page_sync';
    public const LAST_TAXONOMY_SYNC_OPTION = 'intucart_last_taxonomy_sync';

    // Stats and counters
    public const TOTAL_VECTOR_COUNT_OPTION = 'intucart_total_vector_count';
    public const CACHE_HITS_OPTION = 'intucart_cache_hits';
    public const CACHE_MISSES_OPTION = 'intucart_cache_misses';

    // Cache settings
    public const CACHE_REVALIDATE_HOOK = 'intucart_cache_revalidate';

    // Cache keys and groups
    public const USAGE_CACHE_KEY = 'current_usage_status';
    public const USAGE_CACHE_GROUP = 'intucart_usage';
    // Prompts cache
    public const PROMPTS_CACHE_GROUP = 'intucart_prompts';
    public const INITIAL_PROMPTS_CACHE_KEY = 'intucart_initial_prompts_v1';
    public const INITIAL_PROMPTS_CACHE_TTL = 3600; // 1 hour

    // Container refresh actions
    public const REFRESH_SERVICE_ACTION = 'intucart_refresh_service';
    
    // Usage limit actions
    public const USAGE_LIMIT_EXCEEDED_ACTION = 'intucart_usage_limit_exceeded';

    // Search action hooks
    public const SEMANTIC_SEARCH_ACTION = 'intucart_semantic_search';

    // Chat Settings (standardized with itf_chat_ prefix for consistency with CSS theming)
    public const CHAT_OPTION_PREFIX = 'itf_chat_';
    public const ASSISTANT_DEFAULT_WELCOME_MESSAGE = '👋 Hello! How can I help you today?';
    public const ASSISTANT_DEFAULT_CHAT_HEADER_TEXT = 'Chat';
    public const ASSISTANT_DEFAULT_CHAT_MODEL = 'o4-mini';

    public const OPTION_ENABLE_CHAT_ASSISTANT = 'itf_chat_enabled';
    public const OPTION_CHAT_MODEL = 'itf_chat_model';
    public const OPTION_CHAT_HEADER_TEXT = 'itf_chat_header_text';
    public const OPTION_CHAT_CUSTOM_INSTRUCTIONS = 'itf_chat_custom_instructions';
    public const OPTION_CHAT_SITE_DESCRIPTION = 'itf_chat_site_description';
    public const OPTION_CHAT_HEADER_ICON_ID = 'itf_chat_header_icon_id';
    public const OPTION_CHAT_CUSTOM_CSS = 'itf_chat_custom_css';
    public const OPTION_TOGGLE_ICON_ID = 'itf_chat_trigger_icon_id';
    public const OPTION_ASSISTANT_WELCOME_MESSAGE = 'itf_chat_welcome_message';
    public const OPTION_CHAT_WIDGET_POSITION = 'itf_chat_widget_position';
    public const OPTION_CHAT_PRIMARY_COLOR = 'itf_chat_primary_color';
    public const OPTION_CHAT_CARD_LAYOUT = 'itf_chat_card_layout';
    public const OPTION_CHAT_PROMPT_STYLE = 'itf_chat_prompt_style';

    // Chat Header Settings
    public const OPTION_CHAT_HEADER_SUBTITLE = 'itf_chat_header_subtitle';
    public const OPTION_CHAT_HEADER_AVATAR_SHOW_BACKGROUND = 'itf_chat_header_avatar_show_background';
    public const OPTION_CHAT_HEADER_AVATAR_SHOW_BORDER = 'itf_chat_header_avatar_show_border';

    // Chat Greeting/Welcome Settings
    public const OPTION_CHAT_GREETING_ICON_ID = 'itf_chat_greeting_icon_id';
    public const OPTION_CHAT_GREETING_SUBTEXT = 'itf_chat_greeting_subtext';

    // Trigger Button Settings
    public const OPTION_CHAT_TRIGGER_BUTTON_SHOW_BACKGROUND = 'itf_chat_trigger_button_show_background';
    public const OPTION_CHAT_TRIGGER_ICON_SHOW_BORDER = 'itf_chat_trigger_icon_show_border';

    // Chat Theme Settings
    public const OPTION_CHAT_COLOR_SCHEME = 'itf_chat_color_scheme';
    public const OPTION_CHAT_BORDER_RADIUS = 'itf_chat_border_radius';
    public const OPTION_CHAT_ACCENT_COLOR = 'itf_chat_accent_color';
    public const OPTION_CHAT_LINK_COLOR = 'itf_chat_link_color';
    public const OPTION_CHAT_ASSISTANT_BUBBLE_BG = 'itf_chat_assistant_bubble_bg';
    public const OPTION_CHAT_HEADER_BACKGROUND = 'itf_chat_header_background';
    public const OPTION_CHAT_HEADER_TITLE_COLOR = 'itf_chat_header_title_color';
    public const OPTION_CHAT_HEADER_SUBTITLE_COLOR = 'itf_chat_header_subtitle_color';
    public const OPTION_CHAT_HEADER_ICON_COLOR = 'itf_chat_header_icon_color';

    // Chat Button Colors
    public const OPTION_CHAT_SEND_BUTTON_COLOR = 'itf_chat_send_button_color';
    public const OPTION_CHAT_TRIGGER_BUTTON_COLOR = 'itf_chat_trigger_button_color';
    public const OPTION_CHAT_TRIGGER_BUTTON_HOVER_COLOR = 'itf_chat_trigger_button_hover_color';
    public const OPTION_CHAT_TRIGGER_BUTTON_BORDER_COLOR = 'itf_chat_trigger_button_border_color';

    // Chat Widget Background Settings
    public const OPTION_CHAT_WIDGET_BACKGROUND_MODE = 'itf_chat_widget_background_mode';
    public const OPTION_CHAT_WIDGET_BACKGROUND_CUSTOM = 'itf_chat_widget_background_custom';

    // Chat Typography Settings
    public const OPTION_CHAT_FONT_FAMILY = 'itf_chat_font_family';
    public const OPTION_CHAT_CUSTOM_FONT_FAMILY = 'itf_chat_custom_font_family';
    public const OPTION_CHAT_MESSAGE_FONT_SIZE = 'itf_chat_message_font_size';
    public const OPTION_CHAT_MESSAGE_LINE_HEIGHT = 'itf_chat_message_line_height';
    public const OPTION_CHAT_MESSAGE_FONT_FAMILY = 'itf_chat_message_font_family';
    public const OPTION_CHAT_MESSAGE_CUSTOM_FONT_FAMILY = 'itf_chat_message_custom_font_family';
    public const OPTION_CHAT_CARD_FONT_SIZE = 'itf_chat_card_font_size';
    public const OPTION_CHAT_CARD_LINE_HEIGHT = 'itf_chat_card_line_height';

    // Chat Shadow Settings
    public const OPTION_CHAT_WIDGET_SHADOW = 'itf_chat_widget_shadow';

    // Chat Input Field Settings
    public const OPTION_CHAT_INPUT_BACKGROUND = 'itf_chat_input_background';
    public const OPTION_CHAT_INPUT_BORDER = 'itf_chat_input_border';

    // Chat Widget Dimensions
    public const OPTION_CHAT_WIDGET_MAX_WIDTH = 'itf_chat_widget_max_width';
    public const OPTION_CHAT_WIDGET_MAX_HEIGHT = 'itf_chat_widget_max_height';

    // Dark Mode Color Variants (for custom dark mode branding)
    public const OPTION_CHAT_DARK_PRIMARY_COLOR = 'itf_chat_dark_primary_color';
    public const OPTION_CHAT_DARK_ASSISTANT_BUBBLE_BG = 'itf_chat_dark_assistant_bubble_bg';
    public const OPTION_CHAT_DARK_HEADER_BACKGROUND = 'itf_chat_dark_header_background';
    public const OPTION_CHAT_DARK_HEADER_TITLE_COLOR = 'itf_chat_dark_header_title_color';
    public const OPTION_CHAT_DARK_HEADER_SUBTITLE_COLOR = 'itf_chat_dark_header_subtitle_color';
    public const OPTION_CHAT_DARK_HEADER_ICON_COLOR = 'itf_chat_dark_header_icon_color';
    public const OPTION_CHAT_DARK_ACCENT_COLOR = 'itf_chat_dark_accent_color';
    public const OPTION_CHAT_DARK_SEND_BUTTON_COLOR = 'itf_chat_dark_send_button_color';
    public const OPTION_CHAT_DARK_LINK_COLOR = 'itf_chat_dark_link_color';
    public const OPTION_CHAT_DARK_TRIGGER_BUTTON_COLOR = 'itf_chat_dark_trigger_button_color';
    public const OPTION_CHAT_DARK_TRIGGER_BUTTON_HOVER_COLOR = 'itf_chat_dark_trigger_button_hover_color';
    public const OPTION_CHAT_DARK_TRIGGER_BUTTON_BORDER_COLOR = 'itf_chat_dark_trigger_button_border_color';
    public const OPTION_CHAT_DARK_INPUT_BACKGROUND = 'itf_chat_dark_input_background';
    public const OPTION_CHAT_DARK_INPUT_BORDER = 'itf_chat_dark_input_border';
    public const OPTION_CHAT_DARK_WIDGET_BACKGROUND_CUSTOM = 'itf_chat_dark_widget_background_custom';

    // Card Styling Settings (Products and Posts)
    public const OPTION_CHAT_CARD_BACKGROUND = 'itf_chat_card_background';
    public const OPTION_CHAT_DARK_CARD_BACKGROUND = 'itf_chat_dark_card_background';
    public const OPTION_CHAT_CARD_BORDER = 'itf_chat_card_border';
    public const OPTION_CHAT_DARK_CARD_BORDER = 'itf_chat_dark_card_border';
    public const OPTION_CHAT_CARD_HOVER_BG = 'itf_chat_card_hover_bg';
    public const OPTION_CHAT_DARK_CARD_HOVER_BG = 'itf_chat_dark_card_hover_bg';
    public const OPTION_CHAT_CARD_BORDER_RADIUS = 'itf_chat_card_border_radius';
    public const OPTION_CHAT_CARD_SHADOW = 'itf_chat_card_shadow';
    public const OPTION_CHAT_CARD_TITLE_COLOR = 'itf_chat_card_title_color';
    public const OPTION_CHAT_DARK_CARD_TITLE_COLOR = 'itf_chat_dark_card_title_color';
    public const OPTION_CHAT_CARD_TITLE_SIZE = 'itf_chat_card_title_size';
    public const OPTION_CHAT_CARD_TITLE_WEIGHT = 'itf_chat_card_title_weight';
    public const OPTION_CHAT_CARD_META_COLOR = 'itf_chat_card_meta_color';
    public const OPTION_CHAT_DARK_CARD_META_COLOR = 'itf_chat_dark_card_meta_color';
    public const OPTION_CHAT_CARD_DESC_COLOR = 'itf_chat_card_desc_color';
    public const OPTION_CHAT_DARK_CARD_DESC_COLOR = 'itf_chat_dark_card_desc_color';
    public const OPTION_CHAT_CARD_DESC_LENGTH = 'itf_chat_card_desc_length';

    // Post Card Display Options
    public const OPTION_CHAT_SHOW_POST_IMAGE = 'itf_chat_show_post_image';
    public const OPTION_CHAT_SHOW_POST_AUTHOR = 'itf_chat_show_post_author';
    public const OPTION_CHAT_SHOW_POST_DATE = 'itf_chat_show_post_date';
    public const OPTION_CHAT_SHOW_POST_CATEGORY = 'itf_chat_show_post_category';

    // Prompt Chip Styling
    public const OPTION_CHAT_PROMPT_CHIP_BACKGROUND = 'itf_chat_prompt_chip_background';
    public const OPTION_CHAT_DARK_PROMPT_CHIP_BACKGROUND = 'itf_chat_dark_prompt_chip_background';
    public const OPTION_CHAT_PROMPT_CHIP_TEXT_COLOR = 'itf_chat_prompt_chip_text_color';
    public const OPTION_CHAT_DARK_PROMPT_CHIP_TEXT_COLOR = 'itf_chat_dark_prompt_chip_text_color';
    public const OPTION_CHAT_PROMPT_CHIP_BORDER = 'itf_chat_prompt_chip_border';
    public const OPTION_CHAT_DARK_PROMPT_CHIP_BORDER = 'itf_chat_dark_prompt_chip_border';
    public const OPTION_CHAT_PROMPT_CHIP_HOVER_BG = 'itf_chat_prompt_chip_hover_bg';
    public const OPTION_CHAT_DARK_PROMPT_CHIP_HOVER_BG = 'itf_chat_dark_prompt_chip_hover_bg';

    // Message Actions & Timestamps
    public const OPTION_CHAT_SHOW_MESSAGE_ACTIONS = 'itf_chat_show_message_actions';
    public const OPTION_CHAT_SHOW_USER_COPY_BUTTON = 'itf_chat_show_user_copy_button';
    public const OPTION_CHAT_SHOW_MESSAGE_TIMESTAMPS = 'itf_chat_show_message_timestamps';

    // === MCP (MODEL CONTEXT PROTOCOL) SETTINGS ===
    
    // MCP Feature Toggles - Control which AI capabilities are enabled
    public const OPTION_ENABLE_MCP_ORDERS = 'itf_chat_enable_mcp_orders'; // AI can access order data (WooCommerce)
    // Future MCP toggles:
    // public const OPTION_ENABLE_MCP_INVENTORY = 'itf_chat_enable_mcp_inventory'; // AI can check stock levels
    // public const OPTION_ENABLE_MCP_SUPPORT = 'itf_chat_enable_mcp_support'; // AI can access support tickets

    // === PRIVACY & ANALYTICS SETTINGS ===
    
    // Visitor tracking - uses device fingerprinting for unique visitor analytics
    public const OPTION_CHAT_ANALYTICS_ENABLED = 'itf_chat_analytics_enabled'; // Enable visitor tracking (default: true)
    public const OPTION_CHAT_ANALYTICS_CONSENT_REQUIRED = 'itf_chat_analytics_consent_required'; // Require consent before tracking (default: false)
    // public const OPTION_ENABLE_MCP_ACCOUNT = 'itf_chat_enable_mcp_account'; // AI can access user account data

    // === LIVE AGENT SETTINGS ===
    
    // WordPress Settings Groups
    public const SETTINGS_GROUP_LIVE_AGENT_PROVIDER = 'intucart_live_agent_provider';
    public const SETTINGS_GROUP_LIVE_AGENT_BEHAVIOR = 'intucart_live_agent_behavior';
    
    // Live Agent Configuration Options
    public const OPTION_LIVE_AGENT_ENABLED = 'intucart_live_agent_enabled';
    public const OPTION_LIVE_AGENT_PROVIDER = 'intucart_live_agent_provider';
    public const OPTION_LIVE_AGENT_CONFIGURED = 'intucart_live_agent_configured'; // Cached status: are credentials configured?
    public const OPTION_LIVE_AGENT_AUTO_HANDOFF = 'intucart_live_agent_auto_handoff';
    public const OPTION_LIVE_AGENT_MANUAL_HANDOFF = 'intucart_live_agent_manual_handoff';
    public const OPTION_LIVE_AGENT_BUSINESS_HOURS = 'intucart_live_agent_business_hours';
    public const OPTION_LIVE_AGENT_AVAILABILITY_SCHEDULE = 'intucart_live_agent_availability_schedule';
    public const OPTION_LIVE_AGENT_INACTIVITY_TIMEOUT = 'intucart_live_agent_inactivity_timeout';
    public const OPTION_LIVE_AGENT_ESCALATION_PROMPT = 'intucart_live_agent_escalation_prompt';
    public const OPTION_CONTACT_FORM_ENABLED = 'intucart_contact_form_enabled';
    
    // Live Agent Default Values
    public const DEFAULT_LIVE_AGENT_INACTIVITY_TIMEOUT = 600; // 10 minutes (in seconds)
    
    // Live Agent Provider Types
    public const LIVE_AGENT_PROVIDER_NONE = 'none';
    public const LIVE_AGENT_PROVIDER_SLACK = 'slack';
    public const LIVE_AGENT_PROVIDER_ZENDESK = 'zendesk';
    public const LIVE_AGENT_PROVIDER_INTERCOM = 'intercom';
    public const LIVE_AGENT_PROVIDER_DRIFT = 'drift';
    public const LIVE_AGENT_PROVIDER_CUSTOM = 'custom';

    // === WEBHOOK SETTINGS ===
    
    // WordPress Settings Groups
    public const SETTINGS_GROUP_WEBHOOKS = 'intucart_webhook_settings';
    
    // Webhook Configuration Options
    public const OPTION_WEBHOOKS_ENABLED = 'intucart_webhooks_enabled';
    public const OPTION_WEBHOOK_ENDPOINTS = 'intucart_webhook_endpoints'; // Serialized array of webhook configurations
    public const OPTION_WEBHOOK_GLOBAL_SECRET = 'intucart_webhook_global_secret';
    public const OPTION_WEBHOOK_TIMEOUT = 'intucart_webhook_timeout';
    public const OPTION_WEBHOOK_RETRY_ATTEMPTS = 'intucart_webhook_retry_attempts';
    public const OPTION_WEBHOOK_RETRY_DELAY = 'intucart_webhook_retry_delay';
    
    // Webhook Defaults
    public const DEFAULT_WEBHOOK_TIMEOUT = 30; // seconds
    public const DEFAULT_WEBHOOK_RETRY_ATTEMPTS = 3;
    public const DEFAULT_WEBHOOK_RETRY_DELAY = 5; // seconds

    // Admin page hooks
    public const ADMIN_PAGE_HOOK = 'toplevel_page_intucart';
    public const ADMIN_PAGE_ANALYTICS_HOOK = 'intucart_page_intucart-analytics';
    public const ADMIN_PAGE_STATUS_HOOK = 'intucart_page_intucart-status';

    // === SEARCH WIDGET SETTINGS ===
    
    // Search Widget Settings Group
    public const SETTINGS_GROUP_SEARCH_WIDGET = 'intucart_search_widget_settings';
    
    // Search Widget Configuration Options
    public const OPTION_SEARCH_WIDGET_ENABLED = 'itf_search_widget_enabled';
    public const OPTION_SEARCH_WIDGET_PRODUCTS = 'itf_search_widget_products';
    public const OPTION_SEARCH_WIDGET_POSTS = 'itf_search_widget_posts';
    public const OPTION_SEARCH_WIDGET_KEYBOARD_SHORTCUT = 'itf_search_widget_keyboard_shortcut';
    public const OPTION_SEARCH_WIDGET_SHOW_TRIGGER = 'itf_search_widget_show_trigger';
    public const OPTION_SEARCH_WIDGET_TRIGGER_POSITION = 'itf_search_widget_trigger_position';
    
    // Search Widget Theme Settings
    public const OPTION_SEARCH_WIDGET_PRIMARY_COLOR = 'itf_search_widget_primary_color';
    public const OPTION_SEARCH_WIDGET_DARK_PRIMARY_COLOR = 'itf_search_widget_dark_primary_color';
    public const OPTION_SEARCH_WIDGET_COLOR_SCHEME = 'itf_search_widget_color_scheme';
    
    // Search Widget Trigger Button Icon
    public const OPTION_SEARCH_WIDGET_TRIGGER_ICON_ID = 'itf_search_widget_trigger_icon_id';
    
    // Search Widget Trigger Button Colors (Light Mode)
    public const OPTION_SEARCH_WIDGET_TRIGGER_BG = 'itf_search_widget_trigger_bg';
    public const OPTION_SEARCH_WIDGET_TRIGGER_TEXT = 'itf_search_widget_trigger_text';
    public const OPTION_SEARCH_WIDGET_TRIGGER_BORDER = 'itf_search_widget_trigger_border';
    
    // Search Widget Trigger Button Colors (Dark Mode)
    public const OPTION_SEARCH_WIDGET_DARK_TRIGGER_BG = 'itf_search_widget_dark_trigger_bg';
    public const OPTION_SEARCH_WIDGET_DARK_TRIGGER_TEXT = 'itf_search_widget_dark_trigger_text';
    public const OPTION_SEARCH_WIDGET_DARK_TRIGGER_BORDER = 'itf_search_widget_dark_trigger_border';
    
    // Search Widget Defaults
    public const DEFAULT_SEARCH_WIDGET_KEYBOARD_SHORTCUT = 'ctrl+k';
    public const DEFAULT_SEARCH_WIDGET_TRIGGER_POSITION = 'bottom-left';
    
    // Trigger Button Defaults - Light Mode (primary blue, matches chatbot)
    public const DEFAULT_SEARCH_WIDGET_TRIGGER_BG = '#0084ff';
    public const DEFAULT_SEARCH_WIDGET_TRIGGER_TEXT = '#ffffff';
    public const DEFAULT_SEARCH_WIDGET_TRIGGER_BORDER = '#0073e6';
    
    // Trigger Button Defaults - Dark Mode
    public const DEFAULT_SEARCH_WIDGET_DARK_TRIGGER_BG = '#0084ff';
    public const DEFAULT_SEARCH_WIDGET_DARK_TRIGGER_TEXT = '#ffffff';
    public const DEFAULT_SEARCH_WIDGET_DARK_TRIGGER_BORDER = '#0073e6';
}
