<?php

namespace Intucart\Services\Events;

/**
 * Event Data Interface
 *
 * Interface for all event data objects to enforce structure
 */
interface EventDataInterface extends \JsonSerializable
{
    /**
     * Convert to array
     *
     * @return array
     */
    public function toArray(): array;

    /**
     * Create from array
     *
     * @param array $data Data array
     *
     * @return static
     */
    public static function fromArray(array $data): self;
}
