<?php

namespace Intucart\Services\Events;

use Intucart\Services\Events\EventDataInterface;

/**
 * Interface for events
 *
 * This interface defines the contract for all event classes in the system.
 * Each event type should implement this interface and may contain one or more DTOs
 * that implement the EventDataInterface.
 */
interface EventInterface
{
    /**
     * Get event name
     *
     * @return string The unique identifier for this event type
     */
    public function getName(): string;

    /**
     * Get event timestamp
     *
     * @return int Unix timestamp when the event occurred
     */
    public function getTimestamp(): int;

    /**
     * Get user ID
     *
     * @return int The ID of the user who triggered the event
     */
    public function getUserId(): int;

    /**
     * Get product ID
     *
     * For multi-product events like Purchase, this returns null as these events
     * contain multiple products and are handled differently.
     *
     * @return int|null The product ID, or null for multi-product events
     */
    public function getProductId(): ?int;

    /**
     * Get event parameters
     *
     * This method should return a structured array representation of the event data,
     * typically by converting the internal DTOs to arrays.
     *
     * @return array The event data as an associative array
     */
    public function getParameters(): array;

    /**
     * Validate event data
     *
     * Ensures that all required data for this event type is present and valid.
     *
     * @return bool True if the event data is valid, false otherwise
     */
    public function validate(): bool;
}
