<?php

namespace Intucart\Services\Providers\Events;

use Intucart\Services\Managers\EventManager;

/**
 * Interface for event providers
 */
interface EventProviderInterface
{
    /**
     * Constructor
     *
     * @param EventManager $eventManager Event manager instance
     */
    public function __construct(EventManager $eventManager);

    /**
     * Initialize the event provider and set up hooks
     *
     * @return void
     */
    public function initialize(): void;

    /**
     * Get the provider name
     *
     * @return string
     */
    public function getName(): string;

    /**
     * Check if the provider is active
     *
     * @return bool
     */
    public function isActive(): bool;

    /**
     * Track purchase event
     *
     * @param int $orderId Order ID
     *
     * @return void
     */
    public function trackPurchase(int $orderId): void;
}
