<?php

namespace Intucart\Services\Providers\PostTypes;

/**
 * Interface for generic post type providers (products, events, etc.)
 */
interface PostTypeProviderInterface
{
    /**
     * Get a post by ID and type
     *
     * @param int $postId
     * @param string $postType
     * @return mixed|null
     */
    public function getPost(int $postId, string $postType);

    /**
     * Get multiple posts by type and args
     *
     * @param array $args
     * @param string $postType
     * @return array
     */
    public function getPosts(array $args = [], string $postType = 'post'): array;

    /**
     * Build the payload that will be sent to Intucart Cloud / OpenSearch.
     * Must include at minimum: id, title (or name), content, excerpt (optional), postType/entity_type
     * @param int    $postId
     * @param string $postType
     * @param int    $maxDescLength - Increased default to 50KB since chunking handles large content efficiently
     * @return array<string, mixed>  Flat associative array ready for JSON encoding
     */
    public function getCloudPayload(int $postId, string $postType, int $maxDescLength = 50000): array;

    /**
     * Serialize a post for API responses
     *
     * @param mixed $post
     * @param string $postType
     * @param array $additionalData
     * @return array
     */
    public function serializePost(mixed $post, string $postType, array $additionalData = []): array;
}
