<?php

declare(strict_types=1);

namespace Intucart\Shortcodes;

/**
 * Handles the [intucart_assistant_chat] shortcode.
 */
class AssistantChatShortcode
{
    private const SHORTCODE_TAG = 'intucart_assistant_chat';

    /**
     * Registers the shortcode.
     */
    public function initialize(): void
    {
        add_shortcode(self::SHORTCODE_TAG, [$this, 'renderShortcode']);
    }

    /**
     * Renders the shortcode output.
     *
     * @param array $atts Shortcode attributes.
     * @param string|null $content Shortcode content.
     *
     * @return string The HTML output for the shortcode.
     */
    public function renderShortcode($atts = [], ?string $content = null): string
    {
        // Scripts/styles are now enqueued globally via Enqueue::enqueueFrontend
        // Just output the container div that the JavaScript will target
        return '<div class="intucart-assistant-chat-widget">'
             . '<!-- Chat interface will be loaded here by JS -->'
             . '</div>';
    }
}
