<?php

namespace Intucart\Utils;

/**
 * Utility class for processing attributes and ensuring proper JSON encoding.
 * Prevents array/object conflicts when sending data to cloud services.
 */
class AttributeUtils
{
    /**
     * Process attributes to ensure we send either null or a proper object.
     * Prevents sending empty arrays or numeric arrays that cause validation errors.
     *
     * @param array $attributesData Raw attributes data
     * @return array|null Returns null for empty/invalid data, associative array for proper encoding
     */
    public static function processAttributes(array $attributesData): ?array
    {
        // If empty, return null
        if (empty($attributesData)) {
            return null;
        }

        // Filter out empty values
        $filtered = array_filter($attributesData, function ($value) {
            return $value !== null && $value !== '' && $value !== [];
        });

        // If nothing left after filtering, return null
        if (empty($filtered)) {
            return null;
        }

        // If it's a numeric array (would encode as JSON array), return null
        // We only want associative arrays (that encode as JSON objects)
        if (array_keys($filtered) === range(0, count($filtered) - 1)) {
            return null;
        }

        return $filtered;
    }
}
