<?php

/**
 * Plugin Name: Intufind AI
 * Plugin URI: https://intufind.com
 * Description: Complete AI transformation for WordPress and WooCommerce sites. Features semantic
 * search that understands intent, intelligent product recommendations, conversational AI chatbot
 * with memory, real-time analytics, and advanced customer insights. Includes Model Context Protocol
 * (MCP) server for multi-agent automation, automatic content synchronization, ACF integration,
 * and enterprise-grade architecture. Works with or without WooCommerce.
 * Version: 2.2.58
 * Author: Intufind
 * Author URI: https://intufind.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: intufind
 * Domain Path: /languages
 * Requires PHP: 8.0
 */

declare(strict_types=1);

if (!defined('ABSPATH')) {
    exit;
}

use Intucart\Services\Constants;

// Define plugin constants
define('INTUCART_VERSION', '2.2.58');
define('INTUCART_PLUGIN_FILE', __FILE__);
define('INTUCART_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('INTUCART_PLUGIN_URL', plugin_dir_url(__FILE__));
define('INTUCART_PLUGIN_BASENAME', plugin_basename(__FILE__));
define('INTUCART_PLUGIN_SLUG', 'intufind');

// Composer autoloader - Load this FIRST so Dotenv class is available
$autoloader = __DIR__ . '/vendor/autoload.php';

if (file_exists($autoloader)) {
    require_once $autoloader;
} else {
    add_action('admin_notices', function () {
        echo '<div class="notice notice-error"><p>';
        echo esc_html__(
            'Intucart Error: Cannot find autoloader. Ensure Composer dependencies are installed by running "composer install" in the plugin directory.',
            'intucart'
        );
        echo '</p></div>';
    });
    return;
}

// Default API endpoints - can be overridden via wp-config.php constants
if (!defined('INTUFIND_API_URL')) {
    define('INTUFIND_API_URL', 'https://api.intufind.com');
}

if (!defined('INTUFIND_STREAMING_API_URL')) {
    define('INTUFIND_STREAMING_API_URL', 'https://streaming.intufind.com');
}

if (!defined('INTUFIND_OAUTH_URL')) {
    define('INTUFIND_OAUTH_URL', 'https://api.intufind.com');
}

use Intucart\Plugin;

// Initialize plugin
new Plugin();

// Register activation/deactivation hooks
register_activation_hook(INTUCART_PLUGIN_FILE, [Plugin::class, 'activate']);
register_deactivation_hook(INTUCART_PLUGIN_FILE, [Plugin::class, 'deactivate']);
