<?php

/**
 * Intucart Uninstall
 *
 * Uninstalling Intucart deletes tables, options, and other plugin data.
 *
 * @package Intucart
 */

// Exit if accessed directly.
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Add debug logging
if (defined('WP_DEBUG') && WP_DEBUG) {
    error_log('Intucart uninstall.php started execution');
}

// Define plugin directory if not already defined
if (!defined('INTUCART_PLUGIN_DIR')) {
    define('INTUCART_PLUGIN_DIR', plugin_dir_path(__FILE__));
}

// Load Composer autoloader
$autoloader = INTUCART_PLUGIN_DIR . 'vendor/autoload.php';
if (file_exists($autoloader)) {
    require_once $autoloader;
} else {
    if (defined('WP_DEBUG') && WP_DEBUG) {
        error_log('Intucart uninstall error: Composer autoloader not found at ' . $autoloader);
    }
    return;
}

require_once INTUCART_PLUGIN_DIR . 'includes/Plugin.php';

try {
    // Run uninstall
    \Intucart\Plugin::uninstall();

    if (defined('WP_DEBUG') && WP_DEBUG) {
        error_log('Intucart uninstall: Cleanup completed successfully');
    }
} catch (\Exception $e) {
    if (defined('WP_DEBUG') && WP_DEBUG) {
        error_log('Intucart uninstall error: ' . $e->getMessage());
        error_log('Stack trace: ' . $e->getTraceAsString());
    }
}

// Final confirmation log
if (defined('WP_DEBUG') && WP_DEBUG) {
    error_log('Intucart uninstall.php finished execution');
}
