<?php

declare(strict_types=1);

namespace Intufind\AI\Entities;

/**
 * Domain offer data - server-driven UI for domain offers
 */
class DomainOffer
{
    public string $domain;
    public string $message;
    public array $ui;
    public ?array $context;

    public static function fromArray(array $data): self
    {
        $offer = new self();
        $offer->domain = $data['domain'] ?? '';
        $offer->message = $data['message'] ?? '';
        $offer->ui = $data['ui'] ?? [];
        $offer->context = $data['context'] ?? null;
        return $offer;
    }

    /**
     * Get the UI component type ('action_group' or 'form')
     */
    public function getUIComponent(): ?string
    {
        return $this->ui['component'] ?? null;
    }

    /**
     * Get actions if this is an action_group UI
     * @return OfferedAction[]
     */
    public function getActions(): array
    {
        if ($this->getUIComponent() !== 'action_group') {
            return [];
        }
        $actions = [];
        foreach ($this->ui['actions'] ?? [] as $action) {
            $actions[] = OfferedAction::fromArray($action);
        }
        return $actions;
    }
}
