<?php

declare(strict_types=1);

namespace Intufind\AI\Entities;

/**
 * Feedback entity representing user feedback data
 */
class Feedback
{
    /** @var string|null */
    public $id;

    /** @var string */
    public $external_id;

    /** @var string */
    public $rating;

    /** @var string */
    public $source;

    /** @var string|null */
    public $thread_id;

    /** @var string|null */
    public $content_id;

    /** @var string|null */
    public $content_type;

    /** @var string|null */
    public $user_id;

    /** @var string|null */
    public $session_id;

    /** @var string|null */
    public $comment;

    /** @var string|null */
    public $category;

    /** @var string|null */
    public $query_text;

    /** @var string|null */
    public $model_used;

    /** @var string */
    public $tenant_id;

    /** @var string|null */
    public $workspace_id;

    /** @var string */
    public $created_at;

    /** @var string|null */
    public $updated_at;

    /** @var string|null */
    public $ip_address;

    /** @var string|null */
    public $user_agent;

    /** @var array|null */
    public $metadata;

    /**
     * Create Feedback instance from array data
     *
     * @param array $data
     * @return self
     */
    public static function fromArray(array $data): self
    {
        $feedback = new self();

        $feedback->id = $data['id'] ?? null;
        $feedback->external_id = $data['external_id'] ?? '';
        $feedback->rating = $data['rating'] ?? '';
        $feedback->source = $data['source'] ?? '';
        $feedback->thread_id = $data['thread_id'] ?? null;
        $feedback->content_id = $data['content_id'] ?? null;
        $feedback->content_type = $data['content_type'] ?? null;
        $feedback->user_id = $data['user_id'] ?? null;
        $feedback->session_id = $data['session_id'] ?? null;
        $feedback->comment = $data['comment'] ?? null;
        $feedback->category = $data['category'] ?? null;
        $feedback->query_text = $data['query_text'] ?? null;
        $feedback->model_used = $data['model_used'] ?? null;
        $feedback->tenant_id = $data['tenant_id'] ?? '';
        $feedback->workspace_id = $data['workspace_id'] ?? null;
        $feedback->created_at = $data['created_at'] ?? '';
        $feedback->updated_at = $data['updated_at'] ?? null;
        $feedback->ip_address = $data['ip_address'] ?? null;
        $feedback->user_agent = $data['user_agent'] ?? null;
        $feedback->metadata = $data['metadata'] ?? null;

        return $feedback;
    }

    /**
     * Convert to array
     *
     * @return array
     */
    public function toArray(): array
    {
        return array_filter([
            'id' => $this->id,
            'external_id' => $this->external_id,
            'rating' => $this->rating,
            'source' => $this->source,
            'thread_id' => $this->thread_id,
            'content_id' => $this->content_id,
            'content_type' => $this->content_type,
            'user_id' => $this->user_id,
            'session_id' => $this->session_id,
            'comment' => $this->comment,
            'category' => $this->category,
            'query_text' => $this->query_text,
            'model_used' => $this->model_used,
            'tenant_id' => $this->tenant_id,
            'workspace_id' => $this->workspace_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'ip_address' => $this->ip_address,
            'user_agent' => $this->user_agent,
            'metadata' => $this->metadata,
        ], function ($value) {
            return $value !== null && $value !== '';
        });
    }
}
