<?php

declare(strict_types=1);

namespace Intufind\AI\Entities;

/**
 * Offered action in a domain offer
 */
class OfferedAction
{
    public string $id;
    public string $label;
    public ?string $variant;

    public static function fromArray(array $data): self
    {
        $action = new self();
        $action->id = $data['id'] ?? '';
        $action->label = $data['label'] ?? '';
        $action->variant = $data['variant'] ?? null;
        return $action;
    }
}
