<?php

declare(strict_types=1);

namespace Intufind\AI\Entities;

/**
 * Streaming chunk types returned by the chat API
 */
class StreamingChunkType
{
    public const TEXT_DELTA = 'text_delta';         // Streaming text content (data is string)
    public const PRODUCT = 'product';               // Product data (data is product object)
    public const POST = 'post';                     // Post data (data is post object)
    public const POST_DELTA = 'post_delta';         // Post summary streaming delta
    public const PROMPTS = 'prompts';               // Suggested prompts array
    public const DOMAIN_OFFER = 'domain_offer';     // Domain offer (e.g., live agent handoff)
    public const DOMAIN_OFFER_SUCCESS = 'domain_offer_success'; // Domain offer accepted
    public const COMPLETE = 'complete';             // Stream finished
    public const PROGRESS = 'progress';             // Progress indicator
    public const ERROR = 'error';                   // Error message
}
