<?php

declare(strict_types=1);

namespace Intufind\AI\Exceptions;

use Exception;
use Throwable;

/**
 * Base API exception class
 */
class ApiException extends Exception
{
    /** @var int */
    private $statusCode;

    /** @var array */
    private $errorDetails;

    public function __construct(
        string $message = '',
        int $statusCode = 0,
        ?Throwable $previous = null,
        array $errorDetails = []
    ) {
        parent::__construct($message, 0, $previous);
        $this->statusCode = $statusCode;
        $this->errorDetails = $errorDetails;
    }

    public function getStatusCode(): int
    {
        return $this->statusCode;
    }

    public function getErrorDetails(): array
    {
        return $this->errorDetails;
    }

    /**
     * Get a specific error detail
     *
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    public function getErrorDetail(string $key, $default = null)
    {
        return $this->errorDetails[$key] ?? $default;
    }

    /**
     * Check if this is a client error (4xx)
     *
     * @return bool
     */
    public function isClientError(): bool
    {
        return $this->statusCode >= 400 && $this->statusCode < 500;
    }

    /**
     * Check if this is a server error (5xx)
     *
     * @return bool
     */
    public function isServerError(): bool
    {
        return $this->statusCode >= 500 && $this->statusCode < 600;
    }
}
