<?php
/**
 * Chat Settings page template.
 *
 * Configure the floating chat widget.
 * Detailed customization is done via the Intufind Dashboard.
 *
 * @package Intufind
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$is_connected    = get_option( INTUFIND_OPTION_CONNECTED, false );
$chat_enabled    = get_option( Intufind_Chat_Widget::OPTION_ENABLE_CHAT, true );
$publishable_key = get_option( INTUFIND_OPTION_PUBLISHABLE_KEY, '' );
$workspace_id    = get_option( INTUFIND_OPTION_WORKSPACE_ID, '' );
$is_available    = Intufind_Chat_Widget::is_available();
?>

<div class="wrap intufind-wrap">
	<?php
	Intufind_Components::page_header(
		__( 'Chat', 'intufind' ),
		array(
			'subtitle' => __( 'AI-powered chat assistant for your website.', 'intufind' ),
			'icon'     => 'format-chat',
		)
	);

	// Intro notice for new users.
	Intufind_Components::intro_notice(
		'chat_intro',
		sprintf(
			/* translators: %1$s: link to chat widget settings, %2$s: link to styling docs */
			__( 'Add an AI chat assistant that answers visitor questions using your synced content. <a href="%2$s" target="_blank" rel="noopener">Customize colors and styling</a> to match your brand, or configure advanced options in <a href="%1$s" target="_blank" rel="noopener">Chat Widget settings</a> on the Intufind dashboard.', 'intufind' ),
			'https://intufind.com/dashboard?tab=chat-widget',
			'https://intufind.com/docs/wordpress/chatbot/styling'
		),
		array(
			'title'        => __( 'About AI Chat', 'intufind' ),
			'message_html' => true,
		)
	);
	?>

	<?php
	// Show link to web dashboard.
	if ( $is_connected && ! empty( $workspace_id ) ) :
		$dashboard_url = 'https://intufind.com/dashboard/workspaces/' . urlencode( $workspace_id ) . '/chat';
		?>
		<p class="intufind-dashboard-link">
			<span class="dashicons dashicons-external"></span>
			<?php
			printf(
				/* translators: %s: Link to dashboard */
				esc_html__( 'Customize your chat widget on the %s', 'intufind' ),
				'<a href="' . esc_url( $dashboard_url ) . '" target="_blank" rel="noopener">' . esc_html__( 'Intufind Dashboard', 'intufind' ) . '</a>'
			);
			?>
		</p>
		<?php
	endif;
	?>

	<?php if ( ! $is_connected ) : ?>
		<?php
		Intufind_Components::alert(
			__( 'Please connect your account in Settings before configuring the chat widget.', 'intufind' ),
			'warning'
		);
		?>
	<?php elseif ( ! $is_available ) : ?>
		<?php
		Intufind_Components::alert(
			__( 'Chat widget is not available. Please ensure your workspace is properly configured in the Intufind Dashboard.', 'intufind' ),
			'warning'
		);
		?>
	<?php else : ?>
		<div class="intufind-settings">
			<?php
			Intufind_Components::card(
				array(
					'title'       => __( 'Chat Widget', 'intufind' ),
					'description' => __( 'Control whether the floating chat widget appears on your site.', 'intufind' ),
					'render'      => function () use ( $chat_enabled ) {
						?>
						<div class="intufind-search-toggles">
							<div class="intufind-search-toggle">
								<label class="intufind-toggle-row">
									<span class="intufind-toggle-info">
										<span class="intufind-toggle-title">
											<span class="dashicons dashicons-format-chat"></span>
											<?php esc_html_e( 'Enable Chat Widget', 'intufind' ); ?>
										</span>
										<span class="intufind-toggle-description">
											<?php esc_html_e( 'Show the floating AI chat assistant on your website.', 'intufind' ); ?>
										</span>
									</span>
									<span class="intufind-toggle">
										<input
											type="checkbox"
											name="<?php echo esc_attr( Intufind_Chat_Widget::OPTION_ENABLE_CHAT ); ?>"
											class="intufind-toggle__input intufind-chat-option"
											value="1"
											<?php checked( $chat_enabled ); ?>
										/>
										<span class="intufind-toggle__slider"></span>
									</span>
								</label>
							</div>
						</div>
						<?php
					},
				)
			);
			?>

			<!-- Customization Info Card -->
			<div class="intufind-info-card">
				<div class="intufind-info-card__icon">
					<span class="dashicons dashicons-admin-customizer"></span>
				</div>
				<div class="intufind-info-card__content">
					<h3 class="intufind-info-card__title">
						<?php esc_html_e( 'Customize Your Chat Widget', 'intufind' ); ?>
					</h3>
					<p class="intufind-info-card__text">
						<?php esc_html_e( 'Personalize your chat widget\'s appearance, behavior, and responses in the Intufind Dashboard.', 'intufind' ); ?>
					</p>
					<ul class="intufind-info-card__list">
						<li><?php esc_html_e( 'Choose colors, position, and styling', 'intufind' ); ?></li>
						<li><?php esc_html_e( 'Set custom greetings and prompts', 'intufind' ); ?></li>
						<li><?php esc_html_e( 'Configure AI personality and instructions', 'intufind' ); ?></li>
						<li><?php esc_html_e( 'Preview changes in real-time', 'intufind' ); ?></li>
					</ul>
					<?php
					Intufind_Components::link_button(
						__( 'Customize in Dashboard', 'intufind' ),
						'https://intufind.com/dashboard/workspaces/' . urlencode( get_option( INTUFIND_OPTION_WORKSPACE_ID, '' ) ) . '/chat',
						array(
							'variant' => 'primary',
							'target'  => '_blank',
							'icon'    => 'external',
						)
					);
					?>
				</div>
			</div>
		</div>
	<?php endif; ?>
</div>
