<?php
/**
 * Recommendations Settings page template.
 *
 * Configure AI-powered product recommendations for WooCommerce.
 *
 * @package Intufind
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$is_connected     = get_option( INTUFIND_OPTION_CONNECTED, false );
$related_enabled  = get_option( Intufind_Recommendations_Override::OPTION_ENABLE_RELATED, false );
$upsells_enabled  = get_option( Intufind_Recommendations_Override::OPTION_ENABLE_UPSELLS, false );
$cross_sells_enabled = get_option( Intufind_Recommendations_Override::OPTION_ENABLE_CROSS_SELLS, false );
$max_recommendations = get_option( Intufind_Recommendations_Override::OPTION_MAX_RECOMMENDATIONS, 4 );
$cache_duration   = get_option( Intufind_Recommendations_Override::OPTION_CACHE_DURATION, 3600 );
?>

<div class="wrap intufind-wrap">
	<?php
	Intufind_Components::page_header(
		__( 'Recommendations', 'intufind' ),
		array(
			'subtitle' => __( 'AI-powered product recommendations for WooCommerce.', 'intufind' ),
			'icon'     => 'star-filled',
		)
	);
	?>

	<?php
	// Show link to web dashboard.
	$workspace_id = get_option( INTUFIND_OPTION_WORKSPACE_ID, '' );
	if ( $is_connected && ! empty( $workspace_id ) ) :
		$dashboard_url = 'https://intufind.com/dashboard/workspaces/' . urlencode( $workspace_id );
		?>
		<p class="intufind-dashboard-link">
			<span class="dashicons dashicons-external"></span>
			<?php
			printf(
				/* translators: %s: Link to dashboard */
				esc_html__( 'View analytics and insights on the %s', 'intufind' ),
				'<a href="' . esc_url( $dashboard_url ) . '" target="_blank" rel="noopener">' . esc_html__( 'Intufind Dashboard', 'intufind' ) . '</a>'
			);
			?>
		</p>
		<?php
	endif;
	?>

	<?php if ( ! $is_connected ) : ?>
		<?php
		Intufind_Components::alert(
			__( 'Please connect your account in Settings before configuring recommendations.', 'intufind' ),
			'warning'
		);
		?>
	<?php else : ?>
		<div class="intufind-settings">
			<!-- Recommendations Override Card -->
			<?php
			Intufind_Components::card(
				array(
					'title'       => __( 'Product Recommendations', 'intufind' ),
					'description' => __( 'Replace WooCommerce native recommendations with AI-powered suggestions based on product similarity and purchase patterns.', 'intufind' ),
					'render'      => function () use ( $related_enabled, $upsells_enabled, $cross_sells_enabled ) {
						?>
						<form id="intufind-recommendations-form" method="post" action="">
							<?php wp_nonce_field( 'intufind_recommendations_settings', 'intufind_recommendations_nonce' ); ?>

							<div class="intufind-search-toggles">
								<!-- Related Products Toggle -->
								<div class="intufind-search-toggle">
									<label class="intufind-toggle-row">
										<span class="intufind-toggle-info">
											<span class="intufind-toggle-title">
												<span class="dashicons dashicons-products"></span>
												<?php esc_html_e( 'Related Products', 'intufind' ); ?>
											</span>
											<span class="intufind-toggle-description">
												<?php esc_html_e( 'Show AI-powered related products on single product pages instead of category/tag-based suggestions.', 'intufind' ); ?>
											</span>
										</span>
										<span class="intufind-toggle">
											<input
												type="checkbox"
												name="<?php echo esc_attr( Intufind_Recommendations_Override::OPTION_ENABLE_RELATED ); ?>"
												class="intufind-toggle__input intufind-recommendations-option"
												value="1"
												<?php checked( $related_enabled ); ?>
											/>
											<span class="intufind-toggle__slider"></span>
										</span>
									</label>
								</div>

								<!-- Upsells Toggle -->
								<div class="intufind-search-toggle">
									<label class="intufind-toggle-row">
										<span class="intufind-toggle-info">
											<span class="intufind-toggle-title">
												<span class="dashicons dashicons-arrow-up-alt"></span>
												<?php esc_html_e( 'Upsells', 'intufind' ); ?>
											</span>
											<span class="intufind-toggle-description">
												<?php esc_html_e( 'Enhance upsell suggestions with AI recommendations. Manually set upsells are preserved and AI fills remaining slots.', 'intufind' ); ?>
											</span>
										</span>
										<span class="intufind-toggle">
											<input
												type="checkbox"
												name="<?php echo esc_attr( Intufind_Recommendations_Override::OPTION_ENABLE_UPSELLS ); ?>"
												class="intufind-toggle__input intufind-recommendations-option"
												value="1"
												<?php checked( $upsells_enabled ); ?>
											/>
											<span class="intufind-toggle__slider"></span>
										</span>
									</label>
								</div>

								<!-- Cross-sells Toggle -->
								<div class="intufind-search-toggle">
									<label class="intufind-toggle-row">
										<span class="intufind-toggle-info">
											<span class="intufind-toggle-title">
												<span class="dashicons dashicons-cart"></span>
												<?php esc_html_e( 'Cross-sells', 'intufind' ); ?>
											</span>
											<span class="intufind-toggle-description">
												<?php esc_html_e( 'Show AI-powered cross-sell suggestions on the cart page. Manually set cross-sells are preserved.', 'intufind' ); ?>
											</span>
										</span>
										<span class="intufind-toggle">
											<input
												type="checkbox"
												name="<?php echo esc_attr( Intufind_Recommendations_Override::OPTION_ENABLE_CROSS_SELLS ); ?>"
												class="intufind-toggle__input intufind-recommendations-option"
												value="1"
												<?php checked( $cross_sells_enabled ); ?>
											/>
											<span class="intufind-toggle__slider"></span>
										</span>
									</label>
								</div>
							</div>
						</form>
						<?php
					},
				)
			);
			?>

			<!-- Advanced Settings Card -->
			<?php
			Intufind_Components::card(
				array(
					'title'       => __( 'Advanced Settings', 'intufind' ),
					'description' => __( 'Fine-tune recommendation behavior and performance.', 'intufind' ),
					'render'      => function () use ( $max_recommendations, $cache_duration ) {
						?>
						<form id="intufind-recommendations-advanced-form" method="post" action="">
							<?php wp_nonce_field( 'intufind_recommendations_settings', 'intufind_recommendations_advanced_nonce' ); ?>

							<div class="intufind-form-fields">
								<!-- Max Recommendations -->
								<?php
								Intufind_Components::number_input(
									Intufind_Recommendations_Override::OPTION_MAX_RECOMMENDATIONS,
									$max_recommendations,
									array(
										'label'       => __( 'Default Recommendations Count', 'intufind' ),
										'description' => __( 'Default number of products to recommend (can be overridden by theme).', 'intufind' ),
										'min'         => 1,
										'max'         => 12,
										'step'        => 1,
										'class'       => 'intufind-recommendations-option',
									)
								);
								?>

								<!-- Cache Duration -->
								<?php
								Intufind_Components::select_input(
									Intufind_Recommendations_Override::OPTION_CACHE_DURATION,
									$cache_duration,
									array(
										'label'       => __( 'Cache Duration', 'intufind' ),
										'description' => __( 'How long to cache recommendations for improved performance.', 'intufind' ),
										'options'     => array(
											0     => __( 'No caching', 'intufind' ),
											300   => __( '5 minutes', 'intufind' ),
											900   => __( '15 minutes', 'intufind' ),
											1800  => __( '30 minutes', 'intufind' ),
											3600  => __( '1 hour', 'intufind' ),
											7200  => __( '2 hours', 'intufind' ),
											21600 => __( '6 hours', 'intufind' ),
											86400 => __( '24 hours', 'intufind' ),
										),
										'class'       => 'intufind-recommendations-option',
									)
								);
								?>
							</div>
						</form>
						<?php
					},
				)
			);
			?>

			<!-- How It Works Card -->
			<?php
			Intufind_Components::card(
				array(
					'title'  => __( 'How It Works', 'intufind' ),
					'render' => function () {
						?>
						<div class="intufind-info-content">
							<div class="intufind-info-section">
								<h4><?php esc_html_e( 'AI-Powered Similarity', 'intufind' ); ?></h4>
								<p>
									<?php esc_html_e( 'Intufind analyzes product descriptions, attributes, and images to find truly similar products, going beyond simple category matching.', 'intufind' ); ?>
								</p>
							</div>

							<div class="intufind-info-section">
								<h4><?php esc_html_e( 'Preserves Manual Settings', 'intufind' ); ?></h4>
								<p>
									<?php esc_html_e( 'Products you manually set as upsells or cross-sells in WooCommerce are always shown first. AI recommendations fill any remaining slots.', 'intufind' ); ?>
								</p>
							</div>

							<div class="intufind-info-section">
								<h4><?php esc_html_e( 'Automatic Fallback', 'intufind' ); ?></h4>
								<p>
									<?php esc_html_e( 'If the Intufind API is unavailable, recommendations automatically fall back to WooCommerce native suggestions.', 'intufind' ); ?>
								</p>
							</div>

							<div class="intufind-info-section">
								<h4><?php esc_html_e( 'Sync Required', 'intufind' ); ?></h4>
								<p>
									<?php esc_html_e( 'Products must be synced to Intufind to appear in AI recommendations. Use the Sync page to ensure your catalog is indexed.', 'intufind' ); ?>
								</p>
							</div>
						</div>
						<?php
					},
				)
			);
			?>
		</div>
	<?php endif; ?>
</div>
