<?php
/**
 * Status page template.
 *
 * @package Intufind
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$is_connected   = get_option( INTUFIND_OPTION_CONNECTED, false );
$workspace_id   = get_option( INTUFIND_OPTION_WORKSPACE_ID, '' );
$tenant_id      = get_option( INTUFIND_OPTION_TENANT_ID, '' );
$woo_active     = class_exists( 'WooCommerce' );
$mcp_registered = get_option( INTUFIND_OPTION_MCP_REGISTERED, false );
$mcp_error      = get_option( INTUFIND_OPTION_MCP_ERROR, '' );

// Get MCP status.
$mcp = new Intufind_MCP( new Intufind_API() );
$mcp_status = $mcp->get_status();
?>

<div class="wrap intufind-wrap">
	<?php
	Intufind_Components::page_header(
		__( 'Status', 'intufind' ),
		array(
			'subtitle' => __( 'Monitor connection health and system diagnostics.', 'intufind' ),
			'icon'     => 'info-outline',
		)
	);
	?>

	<div class="intufind-settings">
		<?php
		// Connection Status Card.
		Intufind_Components::card(
			array(
				'title'  => __( 'Connection', 'intufind' ),
				'render' => function () use ( $is_connected, $workspace_id, $tenant_id ) {
					?>
					<div class="intufind-status-grid">
						<div class="intufind-status-item">
							<span class="intufind-status-label"><?php esc_html_e( 'Status', 'intufind' ); ?></span>
							<span class="intufind-status-value">
								<?php
								if ( $is_connected ) {
									Intufind_Components::status_indicator( 'connected' );
								} else {
									Intufind_Components::status_indicator( 'disconnected' );
								}
								?>
							</span>
						</div>
						<?php if ( $is_connected ) : ?>
							<div class="intufind-status-item">
								<span class="intufind-status-label"><?php esc_html_e( 'Workspace', 'intufind' ); ?></span>
								<span class="intufind-status-value">
									<code><?php echo esc_html( $workspace_id ); ?></code>
								</span>
							</div>
							<div class="intufind-status-item">
								<span class="intufind-status-label"><?php esc_html_e( 'Dashboard', 'intufind' ); ?></span>
								<span class="intufind-status-value">
									<?php
									Intufind_Components::link_button(
										__( 'Open Dashboard', 'intufind' ),
										'https://intufind.com/dashboard/workspaces/' . urlencode( $workspace_id ),
										array(
											'variant' => 'ghost',
											'target'  => '_blank',
											'icon'    => 'external',
										)
									);
									?>
								</span>
							</div>
						<?php endif; ?>
					</div>
					<?php
				},
			)
		);

		// Environment Card.
		Intufind_Components::card(
			array(
				'title'  => __( 'Environment', 'intufind' ),
				'render' => function () use ( $woo_active ) {
					?>
					<div class="intufind-status-grid">
						<div class="intufind-status-item">
							<span class="intufind-status-label"><?php esc_html_e( 'Plugin Version', 'intufind' ); ?></span>
							<span class="intufind-status-value"><?php echo esc_html( INTUFIND_VERSION ); ?></span>
						</div>
						<div class="intufind-status-item">
							<span class="intufind-status-label"><?php esc_html_e( 'WordPress', 'intufind' ); ?></span>
							<span class="intufind-status-value"><?php echo esc_html( get_bloginfo( 'version' ) ); ?></span>
						</div>
						<div class="intufind-status-item">
							<span class="intufind-status-label"><?php esc_html_e( 'PHP', 'intufind' ); ?></span>
							<span class="intufind-status-value"><?php echo esc_html( PHP_VERSION ); ?></span>
						</div>
						<div class="intufind-status-item">
							<span class="intufind-status-label"><?php esc_html_e( 'WooCommerce', 'intufind' ); ?></span>
							<span class="intufind-status-value">
								<?php if ( $woo_active ) : ?>
									<?php Intufind_Components::badge( defined( 'WC_VERSION' ) ? WC_VERSION : __( 'Active', 'intufind' ), 'success' ); ?>
								<?php else : ?>
									<?php Intufind_Components::badge( __( 'Not installed', 'intufind' ), 'neutral' ); ?>
								<?php endif; ?>
							</span>
						</div>
						<div class="intufind-status-item">
							<span class="intufind-status-label"><?php esc_html_e( 'API URL', 'intufind' ); ?></span>
							<span class="intufind-status-value">
								<code><?php echo esc_html( INTUFIND_API_URL ); ?></code>
							</span>
						</div>
					</div>
					<?php
				},
			)
		);

		// MCP Server Card.
		Intufind_Components::card(
			array(
				'title'  => __( 'MCP Server', 'intufind' ),
				'render' => function () use ( $mcp_status, $woo_active, $is_connected, $mcp_registered, $mcp_error ) {
					?>
					<p class="intufind-description" style="margin-top: 0;">
						<?php esc_html_e( 'Model Context Protocol (MCP) endpoints for AI agent integration.', 'intufind' ); ?>
					</p>

					<?php if ( ! $is_connected ) : ?>
						<?php
						Intufind_Components::alert(
							__( 'Connect your account to enable MCP endpoints.', 'intufind' ),
							'info'
						);
						?>
					<?php else : ?>
						<div class="intufind-status-grid">
							<div class="intufind-status-item">
								<span class="intufind-status-label"><?php esc_html_e( 'Base Endpoint', 'intufind' ); ?></span>
								<span class="intufind-status-value">
									<code><?php echo esc_html( $mcp_status['endpoints']['base'] ); ?></code>
								</span>
							</div>
							<?php if ( $woo_active && ! empty( $mcp_status['endpoints']['domain_orders'] ) ) : ?>
								<div class="intufind-status-item">
									<span class="intufind-status-label"><?php esc_html_e( 'Orders Domain', 'intufind' ); ?></span>
									<span class="intufind-status-value">
										<code><?php echo esc_html( $mcp_status['endpoints']['domain_orders'] ); ?></code>
									</span>
								</div>
								<div class="intufind-status-item">
									<span class="intufind-status-label"><?php esc_html_e( 'Cloud Registration', 'intufind' ); ?></span>
									<span class="intufind-status-value">
										<?php if ( $mcp_registered ) : ?>
											<?php Intufind_Components::status_indicator( 'connected', __( 'Registered', 'intufind' ) ); ?>
										<?php else : ?>
											<?php Intufind_Components::status_indicator( 'disconnected', __( 'Not Registered', 'intufind' ) ); ?>
										<?php endif; ?>
									</span>
								</div>
							<?php endif; ?>
							<div class="intufind-status-item">
								<span class="intufind-status-label"><?php esc_html_e( 'Available Domains', 'intufind' ); ?></span>
								<span class="intufind-status-value">
									<?php if ( ! empty( $mcp_status['domains'] ) ) : ?>
										<?php foreach ( $mcp_status['domains'] as $domain ) : ?>
											<?php Intufind_Components::badge( $domain, 'info' ); ?>
										<?php endforeach; ?>
									<?php else : ?>
										<?php Intufind_Components::badge( __( 'None', 'intufind' ), 'neutral' ); ?>
									<?php endif; ?>
								</span>
							</div>
						</div>

						<?php if ( $woo_active && $mcp_error ) : ?>
							<div style="margin-top: 16px;">
								<?php
								// Check if error is related to HTTPS requirement.
								$is_https_error = strpos( $mcp_error, 'https' ) !== false || strpos( $mcp_error, 'url' ) !== false;
								$error_message  = $is_https_error
									? sprintf(
										/* translators: %s: The specific error message */
										__( 'Orders domain registration failed: Your site must use HTTPS to enable order support in the AI assistant. Please install an SSL certificate. Technical details: %s', 'intufind' ),
										$mcp_error
									)
									: sprintf(
										/* translators: %s: The error message */
										__( 'Orders domain registration failed: %s', 'intufind' ),
										$mcp_error
									);
								Intufind_Components::alert( $error_message, 'error' );
								?>
								<div style="margin-top: 12px;">
									<?php
									Intufind_Components::button(
										__( 'Retry Registration', 'intufind' ),
										array(
											'id'      => 'intufind-retry-mcp',
											'variant' => 'secondary',
											'icon'    => 'update',
										)
									);
									?>
									<span id="intufind-retry-mcp-status" style="margin-left: 12px;"></span>
								</div>
							</div>
						<?php elseif ( ! $woo_active ) : ?>
							<div style="margin-top: 16px;">
								<?php
								Intufind_Components::alert(
									__( 'Install WooCommerce to enable the Orders domain for AI-powered order management.', 'intufind' ),
									'info'
								);
								?>
							</div>
						<?php endif; ?>
					<?php endif; ?>
					<?php
				},
			)
		);
		?>
	</div>
</div>

<style>
.intufind-status-grid {
	display: grid;
	gap: 16px;
}
.intufind-status-item {
	display: flex;
	justify-content: space-between;
	align-items: center;
	padding: 12px 0;
	border-bottom: 1px solid var(--intufind-border-light, #e0e0e0);
}
.intufind-status-item:last-child {
	border-bottom: none;
	padding-bottom: 0;
}
.intufind-status-label {
	font-weight: 500;
	color: var(--intufind-text, #1e1e1e);
}
.intufind-status-value {
	color: var(--intufind-text-muted, #646970);
}
.intufind-status-value code {
	background: var(--intufind-bg, #f0f0f1);
	padding: 2px 8px;
	border-radius: 4px;
	font-size: 12px;
}
.intufind-status-value .intufind-badge {
	margin-left: 4px;
}
.intufind-status-value .intufind-badge:first-child {
	margin-left: 0;
}
</style>
